/**
 * Die Klasse Ticketautomat modelliert einfache Ticketautomaten,
 * die Tickets zu einem Einheitspreis herausgeben.
 *
 * @author David J. Barnes und Michael Klling
 * @version 2016.02.29
 */
public class Ticketautomat {
    // Der Preis eines Tickets dieses Automaten.
    private int preis;
    // Der Betrag, der bisher vom Automatenbenutzer eingeworfen wurde.
    private int bisherGezahlt;
    // Die Geldsumme, die bisher von diesem Automaten eingenommen wurde.
    private int gesamtsumme;

    /**
     * Erzeuge eine Maschine, die Tickets zum angegebenen Preis
     * (in Euro) ausgibt.
     */
    public Ticketautomat(int ticketpreis) {
        preis = ticketpreis;
        bisherGezahlt = 0;
        gesamtsumme = 0;
    }

    /**
     * Nimm den angegebenen Betrag als Anzahlung fr das
     * nchste Ticket.
     */
    public void geldEinwerfen(int betrag) {
        bisherGezahlt = bisherGezahlt + betrag;
    }

    /**
     * Liefere die Hhe des Betrags, der fr das nchste Ticket bereits
     * eingeworfen wurde.
     */
    public int gibBisherGezahltenBetrag() {
        return bisherGezahlt;
    }

    /**
     * Liefere den Preis eines Tickets dieses Automaten (in Euro).
     */
    public int gibPreis() {
        return preis;
    }

    /**
     * Drucke ein Ticket.
     * Aktualisiere die eingenommene Gesamtsumme und setze den gezahlten
     * Betrag auf null.
     */
    public void ticketDrucken() {
        // Den Ausdruck eines Tickets simulieren.
        System.out.println("##################");
        System.out.println("# DBG-Busverkehr");
        System.out.println("# Ticket");
        System.out.println("# " + preis + " Euro.");
        System.out.println("##################");
        System.out.println();

        // Die Gesamtsumme mit dem eingezahlten Betrag aktualisieren.
        gesamtsumme = gesamtsumme + bisherGezahlt;
        // Die bisherige Bezahlung zurcksetzen.
        bisherGezahlt = 0;
    }
}
